addTrans <- function(color,trans)
{ # This function adds transparancy to a color. Define transparancy with an integer between 0 and 255
  # 0 being fully transparant and 255 being fully visable - Works with either color and trans a vector of equal length,
  # or one of the two of length 1.
  
  if (length(color)!=length(trans)&!any(c(length(color),length(trans))==1)) stop("Vector lengths not correct")
  if (length(color)==1 & length(trans)>1) color <- rep(color,length(trans))
  if (length(trans)==1 & length(color)>1) trans <- rep(trans,length(color))
  
  num2hex <- function(x)
  {
    hex <- unlist(strsplit("0123456789ABCDEF",split=""))
    return(paste(hex[(x-x%%16)/16+1],hex[x%%16+1],sep=""))
  }
  rgb <- rbind(col2rgb(color),trans)
  res <- paste("#",apply(apply(rgb,2,num2hex),2,paste,collapse=""),sep="")
  return(res)
}

grpplot <- function(dat, group, col=listByGroup, pch=16, cex=2,legend.loc="rightside",...)
{    ## validity checking should go here.
  if (is.vector(dat)|| ncol(dat)==1) {dat <- as.matrix(dat) } 
  else { dat <- as.data.frame(dat)     }
  
  legend.loc <- match.arg(legend.loc, c("bottomright", "bottom", "bottomleft",
                                        "left", "topleft", "top", "topright",
                                        "right", "center","mousepoint", "rightside"))
  
  group <- factor(group)
  n     <- nlevels(group)
  colr <- list
  pch <- 16  #if (is.null(pch)) unclass(group) else pch[group]
  
  if (ncol(dat) <= 2) {
    if (legend.loc == "rightside") {
      oldpar <- par(mar = par()$mar+c(0,0,0,4),xpd=TRUE)
      plot(dat, col=col, pch=pch, cex=cex, ...)
      text(dat, rownames(dat), col="black", cex=.6)
      legend(par("usr")[2] + 1.5,par("usr")[4],legend=sort(unique(levels(group))), cex=cex, 
             col = colr, pch = pch )
      #col = sort(as.vector(unique(col))), pch= sort(as.vector(unique(pch))) )
      par(oldpar)
    } 
    else if (legend.loc == "mousepoint"){     ## use mouse point to locate legend. 
      plot(dat, col=col, pch=pch, cex=cex, ...)
      legend(locator(1), legend=sort(unique(levels(group))), cex=cex,
             col = colr, #sort(as.vector(unique(col))), 
             pch = sort(as.vector(unique(pch))) )
    } else {
      plot(dat, col=col, pch=pch,cex=cex, ...)
      legend(legend.loc, inset=0.02,legend=sort(unique(levels(group))), cex=cex, 
             col = colr, #sort(as.vector(unique(col))), 
             pch = sort(as.vector(unique(pch))) )
    }
  } else {
    plot(dat, col=col, pch=pch, cex=cex, ...)
  }
}

ar.clust <-function(x,lvar=NULL,method="complete",...)
{
  lvar2=1:ncol(x)
  if(!is.null(lvar))
    lvar2=which(dimnames(x)[[2]]%in%lvar)
  
  mdist=1-abs(cor(x[,lvar2,drop=FALSE]))
  mdist2=cor(x[,lvar2,drop=FALSE])
  hcr <- hclust(as.dist(mdist),method=method)
  ddr <- as.dendrogram(hcr)
  ddr <- reorder(ddr, rowMeans(mdist2))
  plot(ddr, yaxs = "i",...)
  hcr
}

#ar.corplot<-function(mclust, x, cols=redblue(16), keysize=0.5)
ar.corplot<-function(x, cols=redblue(16), keysize=0.5)
{
  #varorder=order.dendrogram(as.dendrogram(mclust))
  lvar1=hc$labels
  lvar2=which(dimnames(x)[[2]]%in%lvar1)
  mdist2=cor(x[,lvar2,drop=FALSE])#[varorder,varorder]
  
  min.raw<--1; max.raw<-1;
  breaks <- seq(min.raw, max.raw,length = length(cols)+1)
  
  hVc<- heatmap.2(mdist2, Rowv=TRUE, Colv=TRUE, col = cols, breaks=breaks,symm=TRUE,scale='none',margin=c(10,10),
                  na.rm=TRUE,distfun = function(c) as.dist(1 - abs(c)), key=TRUE, symkey=TRUE, 
                  keysize=keysize, density.info="none", trace="none",
                  hclustfun=function(m) hclust(m,method=hc$method)) 
}

corProb<-function(x, dfr = nrow(x) - 2) 
{
  R <- cor(x)
  above <- row(R) < col(R)
  r2 <- R[above]^2
  Fstat <- r2 * dfr / (1 - r2)
  R[above] <- 1 - pf(Fstat, 1, dfr)
  R
}

PCbiplot <- function(PC, x="PC1", y="PC2") 
{ # PC being a prcomp object
  data <- data.frame(obsnames=row.names(PC$x), PC$x)
  plot <- ggplot(data, aes_string(x=x, y=y)) + geom_text(alpha=.4, size=3, aes(label=obsnames))
  plot <- plot + geom_hline(aes(0), size=.2) + geom_vline(aes(0), size=.2)
  datapc <- data.frame(varnames=rownames(PC$rotation), PC$rotation)
  mult <- min(
    (max(data[,y]) - min(data[,y])/(max(datapc[,y])-min(datapc[,y]))),
    (max(data[,x]) - min(data[,x])/(max(datapc[,x])-min(datapc[,x])))
  )
  datapc <- transform(datapc,
                      v1 = .7 * mult * (get(x)),
                      v2 = .7 * mult * (get(y))
  )
  plot <- plot + coord_equal() + geom_text(data=datapc, aes(x=v1, y=v2, label=varnames), size = 5, vjust=1, color="red")
  plot <- plot + geom_segment(data=datapc, aes(x=0, y=0, xend=v1, yend=v2), arrow=arrow(length=unit(0.2,"cm")), alpha=0.75, color="red")
  plot
}

getMostSimilar <-  function(j1, point=0.95){ 
  z <- j1
  z[lower.tri(z,diag=TRUE)]=NA
  z <- as.data.frame(as.table(z))
  z <- na.omit(z)
  z <- z[order(-abs(z$Freq)),]
  subset(z, abs(Freq)>point)
}

corGauss <-  function(j1, samp="SampNotFound"){ 
  if(length(j1)<1) return()
  #print("in corGauss")
  j1.cor <<- cor(j1, method="kendall")
  j1.pcor <<- cor2pcor(j1.cor)
  colnames(j1.pcor) <- colnames(j1) 
  rownames(j1.pcor) <- colnames(j1) 
  
  par(mfrow=c(1,1), mar=c(0,0,1,0), mai=c(0,0,1,0))
  png(paste("picts/", samp, "Cluster.png", sep=""), 1000, 800)
  hc<-ar.clust(j1, NULL, lwd=5, method="ward.D2", col.lab="#7C8071", main=paste(samp," Hierarchical Cluster Analysis", sep="") )
  devOff()
  
  
  hc.cut <- cutree(hc, h=(max(hc$height/2)))
  hc.table <- t(table(hc.cut, hc$order))
  rownames(hc.table) <- hc$labels
  
  junk <- as.matrix(lookup[hc$labels,2])
  hctab2 <- cbind(hc.table, junk)
  write.table(hctab2, file=paste("picts/",samp,"cut.txt"), sep="", row.names=TRUE)
  
  mdist2=cor(j1[, which(dimnames(j1)[[2]]%in%hc$labels), drop=FALSE])#[varorder,varorder]
  
  #fnt= 20/length(mdist2)
  fnt<-1
  if(nrow(mdist2)<20) {fnt<-3.0}
  if(nrow(mdist2)<40&&nrow(mdist2)>20) {fnt<-2.0}
  if(nrow(mdist2)>60) {fnt<-0.5}
  
  png(paste("picts/", samp, "Correlation.png", sep=""), 1000, 800)
  heatmap.2(mdist2, Rowv=T, Colv=T,  symm=TRUE, scale='none', 
            margin=c(6+(fnt*2), 6+(fnt*2)), col = redblue(16), breaks=seq(-1, 1,length=17),
            na.rm=TRUE, distfun = function(c) as.dist(1 - abs(c)), cexRow=fnt, cexCol=fnt,
            key=T, symkey=T, keysize=0.5, density.info="none", trace="none", 
            hclustfun=function(m) hclust(m,method=hc$method), main=paste(samp," correlation matrix", sep=""))
  devOff()
  
  #replace all negative correlations & display strongest linkages
  noneg <- j1.cor
  noneg[noneg<0] <- 0
  #noneg <- noneg>quantile(abs(j1.cor))[4]
  noneg <- noneg>.5
  
  graph.cor <- graph.adjacency(adjmatrix=noneg, mode="undirected", weighted=TRUE, diag=FALSE )
  png(paste("picts/", samp,"CorGaussian.png", sep=""), 1000, 800)
  #l <- layout.kamada.kawai(graph.cor)
  #plot(graph.cor, layout=l, vertex.color="cyan", vertex.label.color='black', edge.width=3, edge.color="blue",
  #     main= paste(samp, " Correlation-based Gaussian Graphical Analysis", sep="") )
  plot(graph.cor, vertex.color="cyan", vertex.label.color='black', edge.width=3, edge.color="blue",
       main= paste(samp, " Correlation-based Gaussian Graphical Analysis", sep="") )
  axis(1, labels=FALSE, tick=TRUE)
  axis(2, labels=FALSE, tick=TRUE)
  devOff()
  
  #replace all negative correlations & display strongest linkages
  nolow <- j1.pcor
  nolow[abs(nolow)<quantile(abs(j1.pcor))[4]] <- 0
  #noneg <- noneg>quantile(abs(j1.pcor))[4]
  
  graph.pcor <- graph.adjacency(adjmatrix=nolow, mode="undirected", weighted=TRUE, diag=FALSE )
  E(graph.pcor)$color=ifelse(E(graph.pcor)$weight>0, "blue", "red")
  png(paste("picts/", samp,"Gaussian.png", sep=""), 1000, 800)
  
  #l <- layout.kamada.kawai(graph.pcor)
  #plot(graph.pcor, layout=l, vertex.color="cyan", vertex.label.color='black', edge.width=3,
  #     main= paste(samp, " Partial Correlation-based Gaussian Graphical Analysis", sep="") )
  plot(graph.pcor, vertex.color="cyan", vertex.label.color='black', edge.width=3,
       main= paste(samp, " Partial Correlation-based Gaussian Graphical Analysis", sep="") )
  
  axis(1, labels=FALSE, tick=TRUE)
  axis(2, labels=FALSE, tick=TRUE)
  devOff()
}  

corGauss2 <-  function(j1, hc, samp="SampNotFound"){ 
  #print("in corGauss")
  j1.cor <<- cor(j1, method="kendall")
  j1.pcor <<- cor2pcor(j1.cor)
  colnames(j1.pcor) <- colnames(j1) 
  rownames(j1.pcor) <- colnames(j1) 
  
  #par(mfrow=c(1,1), mar=c(0,0,1,0), mai=c(0,0,1,0))
  #png(paste("picts/", samp, "Cluster.png", sep=""), 1000, 800)
  #hc<-ar.clust(j1, NULL, lwd=5, method="ward.D2", col.lab="#7C8071", main=paste(samp," Hierarchical Cluster Analysis", sep="") )
  #dev.off()
  #dev.off()
  
  hc.cut <- cutree(hc, h=(max(hc$height/2)))
  hc.table <- t(table(hc.cut, hc$order))
  rownames(hc.table) <- hc$labels
  write.table(hc.table, file=paste("picts/", samp,"cut.txt"), sep="\t", row.names=TRUE)
  mdist2=cor(j1[, which(dimnames(j1)[[2]]%in%hc$labels), drop=FALSE])#[varorder,varorder]
  
  #fnt= 20/nrow(mdist2)
  fnt<-1
  if(nrow(mdist2)<20) {fnt<-3.0}
  if(nrow(mdist2)<40&&nrow(mdist2)>20) {fnt<-2.0}
  if(nrow(mdist2)>60) {fnt<-0.5}
  
  png(paste("picts/", samp, "Correlation.png", sep=""), 1000, 800)
  heatmap.2(mdist2, Rowv=hc$order, Colv=hc$order,  symm=TRUE, scale='none', 
            margin=c(6+(fnt*2), 6+(fnt*2)), col = redblue(16), breaks=seq(-1, 1,length=17),
            na.rm=TRUE, distfun = function(c) as.dist(1 - abs(c)), 
            key=T, symkey=T, keysize=0.5, density.info="none", trace="none",
            dendrogram = "row", cexRow=fnt, cexCol=fnt,
            #dendrogram = "row", cexRow=3, cexCol=2,
            #hclustfun=function(m) hclust(m,method=hc$method), 
            main=paste(samp," correlation matrix", sep="")) 
  devOff()
  
  
  #replace all negative correlations & display strongest linkages
  noneg <- j1.cor
  noneg[noneg<0] <- 0
  #noneg <- noneg>quantile(abs(j1.cor))[4]
  noneg <- noneg>.5
  
  graph.cor <- graph.adjacency(adjmatrix=noneg, mode="undirected", weighted=TRUE, diag=FALSE )
  png(paste("picts/", samp,"CorGaussian.png", sep=""), 1000, 800)
  l <- layout.kamada.kawai(graph.cor, niter=3000)
  plot(graph.cor, layout=l, vertex.color="cyan", vertex.label.color='black', edge.width=3, edge.color="blue",
       main= paste(samp, " Correlation-based Gaussian Graphical Analysis", sep="") )
  axis(1, labels=FALSE, tick=TRUE)
  axis(2, labels=FALSE, tick=TRUE)
  devOff()
  
  #replace all negative correlations & display strongest linkages
  nolow <- j1.pcor
  nolow[abs(nolow)<quantile(abs(j1.pcor))[4]] <- 0
  #noneg <- noneg>quantile(abs(j1.pcor))[4]
  
  graph.pcor <- graph.adjacency(adjmatrix=nolow, mode="undirected", weighted=TRUE, diag=FALSE )
  E(graph.pcor)$color=ifelse(E(graph.pcor)$weight>0, "blue", "red")
  png(paste("picts/", samp,"Gaussian.png", sep=""), 1000, 800)
  l <- layout.kamada.kawai(graph.pcor, niter=3000)
  plot(graph.pcor, layout=l, vertex.color="cyan", vertex.label.color='black', edge.width=3,
       main= paste(samp, " Partial Correlation-based Gaussian Graphical Analysis", sep="") )
  axis(1, labels=FALSE, tick=TRUE)
  axis(2, labels=FALSE, tick=TRUE)
  devOff()
}  

writeExcel <- function(data, file="FileNotPassed.xlsx"){
  newwb <- createWorkbook()
  sheettemp <- createSheet(newwb)
  addDataFrame(data, sheettemp, startRow=2, startColumn=2, col.names=T, row.names=T)
  saveWorkbook(newwb, paste("debug/", file, ".xlsx", sep="")) 
}

fillDataPage <- function(data, name, page){
  Page <-sheets[[page]]  
  td <- data
  glu2 <- setNames(data.frame(deSign[,2]), c("SampID"))
  ss1 <- setNames(data.frame(rowSums(td)), c(paste(name,"_AllSum")))
  ss2 <- setNames(data.frame(rowSums(td %>% select(matches('Pos')))), c(paste(name,"Pos_Sum")) )
  ss3 <- setNames(data.frame(rowSums(td %>% select(matches('Neg')))), c(paste(name,"Neg_Sum")) )
  td[, 'empty'] = NA
  glu2[, 'empty'] = NA
  addDataFrame(cbind(glu2, td, ss1, ss2, ss3), Page, startRow=1, startColumn=1, row.names=T, col.names=T)
  rm(Page, td, Glu2, ss1, ss2, ss3)
}

ts2swR <- function(data, k){
  #narrow <- data[,c(1,3,k)]
  narrow <- inFile[,c(1,3,k)]
  narrowMelt <- melt(narrow, id=c("SampleId", "BinID"))
  narrowMelt$value <- as.numeric(gsub(",","", narrowMelt$value))   # make sure they are numbers
  temp <- dcast(narrowMelt, SampleId ~ BinID, preserve.na = FALSE)  # if this fails then it is likely the edisign has an error
  dataSW <- temp[,-1]
  #  NA values are backfilled with random values less than 0.0001
  dataSW[dataSW==0] <- 1                          #  This makes the zero value known
  #dataSW[dataSW==0] <- sample(zeroreplacement, 1)  #  This removes the zero value
  dataSW[is.na(dataSW)] <- sample(zeroreplacement, 1)
  #  dataSW <- dataSW[]+zeroreplacement
  
  rownames(dataSW) <- rownames(deSign)
  return(dataSW)
}
    
ts2swAUC <- function(data, k){
      narrow <- data[,c(1,3,k)]
    narrowMelt <- melt(narrow, id=c("SampleId", "BinID"))
    narrowMelt$value <- as.numeric(gsub(",","", narrowMelt$value))   # make sure they are numbers
    temp <- dcast(narrowMelt, SampleId ~ BinID, preserve.na = FALSE)  # if this fails then it is likely the edisign has an error
    dataSW <- temp[,-1]
    #remove decimals in all values
    #dataSW[] <- round(dataSW[,],0)
    # C13 orphans (IS-Only bins) are exported as zeros so we make them equal to 1 to find all truely missing C12 components
     dataSW[dataSW==0] <- sample(onereplacement, 1)
    #dataSW[dataSW==0] <- onereplacement
    #  NA values are backfilled with random values less than 0.0001 to make dataset less sparse
    dataSW[is.na(dataSW)] <- sample(zeroreplacement, 1)
    #dataSW[is.na(dataSW)] <- -1  #sample(zeroreplacement, 1)
    #remove decimals in all values
    dataSW[] <- round(dataSW[,],0)    
  
  rownames(dataSW) <- rownames(deSign)
  return(dataSW)
}

zeroreplacement <- runif(200, 0, 0.00001)
onereplacement <- runif(200, .99, 1)

refactor <- function(x) {
  x <- factor(x, levels=levels(x)[levels(x) %in% x] )
  return(x)
}

devOff <- function(){
  while(length(dev.list())>0) {
    dev.off()
  }
}

# Create a function to convert all columns to UTF-8 encoding,
# dropping any characters that can't be converted.
df_convert_utf8 <- function(df_data){
  
  # Convert all character columns to UTF-8
  # Source: https://stackoverflow.com/questions/54633054/dbidbwritetable-invalid-multibyte-string
  df_data[,sapply(df_data,is.character)] <- sapply(
    df_data[,sapply(df_data,is.character)],
    iconv,"WINDOWS-1252","UTF-8",sub = "")
  
  return(df_data)
}
