createDesign <- function(inFile) { # Uses new import columns as of 4.2.75
  
  # deSign associates files and samples to experimental groups
  des1 <- unique(inFile[,c(3, 17)])    # des1 <-  unique(inFile[,c("SampleId", "Dilution")])
  rownames(des1) <- des1[,1] 
  des2 <- des1[order(des1[,1]),]
  # des2[,2] <- as.numeric(gsub("\\D", "", des2[,2]))   #  To remove export errors with characters in them
  des3 <- as.factor(des2[,2])
  SampNumber <- as.matrix(1:length(des1$SampleId))
  deSign <- cbind(SampNumber, des2, des3)
  rownames(deSign) <- paste("RS#",formatC(deSign[,1], width=3, flag=0), sep="")
  colnames(deSign) <- c("SampNumber", "UserID", "ExperimentalGroup", "GroupFactor")
  rm(des1, des2, des3, SampNumber)
  #assign(deSign, deSign, pos=1 )     # used
  return(deSign)
}  #end of createDesign
  
createFiles <- function(inFile) {
  # # files associates files and their attributes with samples 
  # # files <-  unique(inFile[,c("SampleId", "FileName", "AcqMethod", "Dilution")]) #, "NormalizationFactor")])
   files <- unique(inFile[,c(3, 2, 17, 18)])
   files <- files[with(files, order(SampleId)), ]
   rownames(files) <- files[,4]
   colnames(files) <- c("UserID", "AcqMethod", "ExperimentalGroup", "FileName" )
   return(files)
}   # end of createFiles
 
createLookup <- function(inFile) { 
   # Lookup associates all compounds found with their properties - valid from 4.2.75
   lookup <- unique(inFile[,c("BinID", "Name", "ID", "MF", "BinC12mz", "BinRT", "InChiKey2D", "SupCorrC13Inten", "LibName", "ID.conf.")])
   #lookup <- unique(inFile[,c(1, 11, 10, 12, 4, 7, 13, 14, 16, 15)])
   lookup[,2] <- iconv(lookup[,2], from="ISO-8859-1")   # test for bad characters
   rownames(lookup) <- lookup[,1]
   IDMechanism <- paste(lookup$ID.source, ": ", lookup$LibName, ", confidence =", lookup$ID.conf.)
   lookup <- cbind(lookup[,1:7], IDMechanism)
   lookup <- lookup[with(lookup, order(BinID)), ]
   #lookup <- df_convert_utf8(lookup)
   return(lookup)
}  # end createLookup
   
STATAB <- function(Din) {
  ###  doStatsPackage - does basic stats Anova, calculates everything needed for the stats page
  # creates data.pScores and data.pTop1
  #  wb <- createWorkbook()          for debug
  #  Din <- DATA for debug 
  
  #create the table to will use 
  data.pScores <<- as.matrix(Din[1:2,])
  colnames(data.pScores)<-colnames(Din)
  rownames(data.pScores) <- c("p-value", "F-value") 
  data.pScores <- t(data.pScores)
  
  # calculate p values for all compounds store in data.pScore for listing in the Stats tab
  for (i in 1:(ncol(Din))){
    lmodel <- lm(Din[,i] ~ deSign[,3], data=Din)
    Result<-anova(lmodel)
    data.pScores[i,1] <- as.numeric(Result$P[1])
    data.pScores[i,2] <- as.numeric(Result$F[1])
    }
  
  #  Make pTop1 - the dataset of the top 33% compounds for scoring
  temp <- sort(data.pScores[,1], decreasing=F)   # sort all pvalues
  pNum <- round(nrow(data.pScores)/3)            # what cell is at 33% of the highest values  
  pTop1  <- (which(data.pScores[,1]<temp[pNum] & data.pScores[,1]<=0.05) ) #Top 33% of predictors less any >0.05
  data.pTop1 <<- Din[,pTop1]
  #names.pTop1 <- lookup[colnames(data.pTop1),1]
  
  # finish data.pScores for insertion
  data.pScoreNames <- data.frame(lookup[rownames(data.pScores),c(2,4)])
  rownames(data.pScoreNames) <- rownames(data.pScores)
  colnames(data.pScoreNames) <- c("compounds", "MF")
  data.pScoreNames$MF <- as.character(data.pScoreNames$MF)
  
  data.pScores <- data.frame(cbind(data.pScoreNames, data.pScores ))
  data.pScores$p.value <- as.numeric(data.pScores$p.value)
  data.pScores$F.value <- as.numeric(data.pScores$F.value)
  
  #----------------- end analysis/anova  ---------Start plot/anova
  
  BaseStat <- paste("picts/TopStatP1-Cluster", tkn, ".png", sep="")
  if(length(data.pTop1)>2) {
    par(mfrow=c(1,1), mar=c(0,0,1,0), mai=c(0,0,1,0))
    png(BaseStat, 1000, 800)
    hc <- ar.clust(data.pTop1, NULL, lwd=5, method="ward.D2", col.lab="#7C8071", main=paste("Hierarchical Cluster of top cmpds", tkn, sep="") )
    devOff()
  }
  
  # --------------   sheetBS - fills in basic stat tab
  addWorksheet(wb, "Anova") # , sheetName="MNorm")
  
  Stamp <- as.data.frame(paste("This tab shows the results of a regression of all compounds by the experimental design.  Recommend: sort by p value"))
  writeData(wb, "Anova", Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
  
  writeDataTable(wb, sheet="Anova", x=data.pScores, startRow=3, startCol=2, rowNames=T, colNames=T)
  setColWidths(wb, "Anova", cols=2:4, widths = 22)
  addStyle(wb, "Anova", style = createStyle(numFmt="0.00E+00"), rows = 3:nrow(data.pScores), cols = 5, gridExpand = TRUE, stack = T)
  addStyle(wb, "Anova", style = createStyle(numFmt="0.000"), rows = 3:nrow(data.pScores), cols = 6, gridExpand = TRUE, stack = T)
  insertImage(wb, "Anova", BaseStat, startRow=3,  startCol=8)
  
  AnovaList <- list(
    pTOP1  = data.pTop1,
    pScores  = data.pScores 
  ) # end list
  
  return(AnovaList)
  #saveWorkbook(wb, paste("reports/RR_TEST.xlsx", sep=""), overwrite = T )  # for debug
  
}   # end of function STATab

RFTAB <- function(Din) {
  ### Random Forest script
  #  wb <- createWorkbook()          for debug
  #  Din <- DATA                     for debug 
  set.seed(1)
  numS = length(Din)/3
  
  rfmodTreat <- randomForest(Din, deSign[,4], ntree = 3000, importance=TRUE, proximity=TRUE, na.action=na.omit)
  
  if(length(importance(rfmodTreat, type=1))<numS) {numS <- length(importance(rfmodTreat, type=1))}
  temp <- sort(importance(rfmodTreat, type=1), decreasing=TRUE)[numS]
  RFTop1 <- (which(importance(rfmodTreat,type=1)>=temp)) #Toppredictors
  
  data.RFTop1 <<- Din[,RFTop1]
 
  confusion1 <- rfmodTreat$confusion
  RF1topCMPDS <- as.matrix(importance(rfmodTreat)[order(-importance(rfmodTreat)[,"MeanDecreaseAccuracy"] ),])
  junk <- as.matrix(lookup[rownames(RF1topCMPDS),2])
  #rownames(RF1topCMPDS) <- junk[,1] 
  RF1topCMPDS <- cbind(junk,RF1topCMPDS) 
  
  rfmodTreat2 <- randomForest(data.RFTop1, deSign[,3], ntree = 3000,importance=TRUE,proximity=TRUE, na.action=na.omit)
  
  quant2 <- quantile(abs(importance(rfmodTreat2, type=1)), probs=seq(0, 1, .2 ))[5]
  topPredictors2 <- (which(importance(rfmodTreat2,type=1)>quant2)) #Toppredictors
  data.RFTop2 <-data.RFTop1[,topPredictors2]
  
  
  confusion2 <- rfmodTreat2$confusio
  RF2topCMPDS <- importance(rfmodTreat2)[order(-importance(rfmodTreat2)[,"MeanDecreaseAccuracy"] ),]
  junk <- as.matrix(lookup[rownames(RF2topCMPDS),2])
  RF2RF2topCMPDS <- cbind(junk,RF2topCMPDS) 
  
  #nmbConv <- data.frame(lapply(RF2topCMPDS,as.numeric))
  #RF1AllImp <- cbind(allimpTmp[,1],nmbConv[,-1], stringsAsFactors = FALSE )
  #rownames(RF1AllImp) <- rownames(allimpTmp)
  
  RF2topCMPDSTmp <- as.data.frame(cbind(junk, RF2topCMPDS[,]))
  confusion1Tmp <- as.data.frame(confusion1[,])
  confusion2Tmp <- as.data.frame(confusion2[,])
  
  # ---------------------------  end analysis/forest
  
  # -------------------------------start plot/forest  # Create images
  
  RF1Importance <- paste("picts/RF1Importance", tkn, ".png")
  png(RF1Importance)
  varImpPlot(rfmodTreat, pch = 16, cex=.5, col="blue", main=paste("RF1 Importance (All compounds)", tkn, sep="") )
  devOff()
  
  RF2Importance <- paste("picts/RF2Importance", tkn, ".png")
  png(RF2Importance)
  varImpPlot(rfmodTreat2, pch = 16, cex=.5, col="blue", main=paste("RF2 Importance (pruned compounds)", tkn, sep="") )
  devOff()
  
  # needed to get numbers into plot
  fit <- cmdscale(as.dist(1-rfmodTreat$proximity), eig=TRUE, k=knum); 
  #RF1Plot <<- paste("picts/RF1Plot", tkn, ".png")
  png(RFMod1)
  x <- fit$points[,1]
  shift <- abs((max(x)-min(x))/100)
  y <- fit$points[,2]
  plot(x, y, xlab="Coordinate 1", ylab="Coordinate 2", col=listByGroup, pch=20, cex=3, main=paste("RF1 Model clusters ", tkn, sep=""))
  text(x-shift, y, row.names(DATA), xlab="Coordinate 1", ylab="Coordinate 2", col=listByGroup, pos=4, cex=.8)
  devOff() 
  
  fit2 <- cmdscale(as.dist(1-rfmodTreat2$proximity), eig=TRUE, k=knum);
  RF2Plot <<- paste("picts/RF2Plot", tkn, ".png")
  png(RFMod2)
  x <- fit2$points[,1]
  shift <- abs((max(x)-min(x))/100)
  y <- fit2$points[,2]
  plot(x, y, xlab="Coordinate 1", ylab="Coordinate 2", col=listByGroup, pch=20, cex=3, main=paste("RF2 Model clusters ", tkn, sep=""))
  text(x-shift, y, row.names(DATA), xlab="Coordinate 1", ylab="Coordinate 2", col=listByGroup, pos=4,
       cex=.7, main="RF(2) by Treatment1")
  devOff() 
  
  RF1Group <- paste("picts/RF1Group", tkn, ".png")
  png(RF1Group)
  grpplot(fit$points[,1:knum], deSign[,3], cex=1.3,main=paste("RF by All cmpds", tkn, sep=""))
  devOff() 
  
  RF2Group <- paste("picts/RF2Group", tkn, ".png")
  png(RF2Group)
  grpplot(fit2$points[,1:knum], deSign[,3], cex=1.3, main=paste("RF by Pruned cmpds", tkn))
  devOff() 
  
  # ------------------------------------end plot/forest

  RFavg1 <- (sum(confusion1[,nrow(confusion1)+1])/nrow(confusion1))
  stamp1 <- as.data.frame(paste("The error in this Random Forest first pass (RF1 - which used all ", length(DATA), " compounds was ", format(RFavg1, digits = 4 )))
  RFavg2 <- (sum(confusion2[,nrow(confusion2)+1])/nrow(confusion2))
  stamp2 <- as.data.frame(paste("The error in this Random Forest second pass (which used a pruned set of ", length(data.RFTop1), " of the most significant compounds from RF1) was ", format(RFavg2, digits = 4)))
 
  addWorksheet(wb, "Random Forest") # , sheetName="MNorm")
  
  Stamp <- as.data.frame(paste("This tab shows results from two sequential Random Forest analyses"))
  writeData(wb, "Random Forest", Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
   
  writeData(wb, "Random Forest", stamp1, startRow=3, startCol=2, rowNames=F, colNames=F)
  writeData(wb, "Random Forest", confusion1, startRow=4, startCol=2, colNames=T, rowNames=T)
  
  writeData(wb, "Random Forest", stamp2, startRow=15, startCol=2, rowNames=F, colNames=F)
  writeData(wb, "Random Forest", confusion2, startRow=17, startCol=2, colNames=T, rowNames=T)
  
  writeData(wb, "Random Forest", RF1topCMPDS, startRow=30, startCol=2, colNames=T, rowNames=T)
  writeData(wb, "Random Forest", RF2topCMPDS, startRow=30, startCol=16, colNames=T, rowNames=T)
  
  addStyle(wb, "Random Forest", style=createStyle(numFmt="0.000"), rows=1:nrow(RF1topCMPDS)+30, cols = 3:12, gridExpand = T, stack = T )
  addStyle(wb, "Random Forest", style=createStyle(numFmt="0.000"), rows=1:nrow(RF1topCMPDS)+30, cols = 16:25, gridExpand = T, stack = T )
  
  insertImage(wb, "Random Forest", RFMod1, width=2, height=2, startRow=4, startCol=length(confusion1[,1])+5 )
  insertImage(wb, "Random Forest", RFMod2,  width=2, height=2, startRow=17, startCol=length(confusion1[,1])+5 )
  insertImage(wb, "Random Forest", RF1Importance,  width=4, height=2, startRow=4, startCol=length(confusion1[,1])+8 )
  insertImage(wb, "Random Forest", RF2Importance,  width=4, height=2, startRow=17, startCol=length(confusion1[,1])+8 )
  insertImage(wb, "Random Forest", RF1Group,  width=2, height=2, startRow=4, startCol=length(confusion1[,1])+13 )
  insertImage(wb, "Random Forest", RF2Group,  width=2, height=2, startRow=17, startCol=length(confusion1[,1])+13 )
  
  insertImage(wb, "Random Forest", "picts/legend.png", width=3, height=4, startRow=2, startCol=length(confusion1[,1])+17 )
  
  #saveWorkbook(wb, paste("reports/RR_TEST.xlsx", sep=""), overwrite = T )  # for debug
  
  RFList <- list(
    rfTOP1  = data.RFTop1,
    rfTOP2  = data.RFTop2,
    RFnames1 = RF1topCMPDS,
    RFnames2 = RF2topCMPDS,
    Conf1  = confusion1,
    Conf2  = confusion2
  ) # end list
  
  return(RFList)
  
}    # end of function RFTab

PCATAB <- function(Din) {
  # for debug Din <- DATA
  
  if(length(row.names(deSign))>10){snum=10}else{snum=length(row.names(deSign))}
  
  #---------------Data generation
  data.pcaRaw <-prcomp(Din)  #  either MDATA with scaling or DATA without scaling work
  data.pca <- data.pcaRaw
  
  # ------------------Build top significant compounds list using top 50 of PC1, PC2, and PC3
  tnum <- nrow(data.pca$rotation)/6
  pca.rotations <- data.pca$rotation
  temp <- sort(abs(pca.rotations[,1]), decreasing=TRUE)[tnum] # find value of tnum compound PC1
  PCATop1 <- (which(abs(pca.rotations[,1])>=temp ) ) 
  temp <- sort(abs(pca.rotations[,2]), decreasing=TRUE)[tnum] # find value of tnum compound PC2
  PCATop2 <- (which(abs(pca.rotations[,2])>=temp ) ) 
  temp <- sort(abs(pca.rotations[,3]), decreasing=TRUE)[tnum] # find value of tnum compound PC3
  PCATop3 <- (which(abs(pca.rotations[,3])>=temp ) ) 
  
  topPredictors <- unique(c(PCATop1, PCATop2, PCATop3))
  data.PCATop1 <<- Din[,topPredictors]                 # build data matrix of top compounds 

   # --------------- create empty table for export
   data.pca.summary <- cbind(data.pca$sdev^2/sum(data.pca$sdev^2), data.pca$sdev)[1:snum,]
   colnames(data.pca.summary) <- c("%TotVar", "SD")
   rownames(data.pca.summary) <-paste("PC", seq(1,nrow(data.pca.summary),1), sep="")
    
   data.pca2<-prcomp(data.PCATop1, scale=T)
   data.pca2.summary <- cbind(data.pca2$sdev^2/sum(data.pca2$sdev^2), data.pca2$sdev)[1:snum,]
   colnames(data.pca2.summary) <- c("%TotVar", "SD")
   rownames(data.pca2.summary) <-paste("PC", seq(1,nrow(data.pca2.summary),1), sep="")
  
   # recast the data
   pcax <- data.pca$x[,1:snum]
   pcay <- data.pca$rotation[,1:snum]
   data.pca.recast <- pcax %*% t(pcay)
  
  # calculate P values for experimental design
  pcaPScores <- as.matrix(1:10)
  rownames(pcaPScores) <- colnames(data.pca$x[,1:10])
  colnames(pcaPScores)[1] <- "p Design"
  
  for (i in 1:10){
    lmodel <- lm(data.pca$x[,i] ~ deSign[,3], data=as.data.frame(data.pca$x[,i]) )
    Result <- anova(lmodel)
    pcaPScores[i] <- Result$P[1]
    } 
  
  # calculate p scores for concentration
  pcaPScores2 <- as.matrix(1:10)
  rownames(pcaPScores2) <- colnames(data.pca$x[,1:10])
  if(Lab>2)  { colnames(pcaPScores2)[1] <- "p Reg" }
  if(Lab==1) { colnames(pcaPScores2)[1] <- "p Lab1" }
  if(Lab==2) { colnames(pcaPScores2)[1] <- "p Lab2" }
  
  for (i in 1:10){
    #lmodel <- lm(data.pca$x[,i] ~ deSign[,5], data=as.data.frame(data.pca$x[,i]) ) # for RR
    lmodel <- lm(data.pca$x[,i] ~ deSign[,3], data=as.data.frame(data.pca$x[,i]) )
    Result <- anova(lmodel)
    pcaPScores2[i] <- Result$P[1]
  } 
  
  pcaSummary <<- as.data.frame(cbind(data.pca.summary[],pcaPScores[], pcaPScores2[]))
  
  plist <- order(pcaPScores, decreasing=F)
  pcaRotation <- as.data.frame(data.pca$rotation[,1:10])
  dataPCA <- as.data.frame(data.pca$x[,1:10])
  
  # -----------------------------------------------------end analysis/pca
  
  # start plot/pca -----   the rest is picts or stuffing
  # the first 3 are used in the summary
  
  #FigPCARAW <- paste("picts/PCARaw", tkn, ".png", sep="")
  png(PCAraw)
  plot(t(data.pcaRaw$x[,1]), t(data.pcaRaw$x[,2]), col=listByGroup, pch=16, xlab="PC1", ylab = "PC2", main=paste("PCA Full dataset (PC1 by PC2) ", tkn), font=3, cex=2)
  text(t(data.pcaRaw$x[,1])+abs((max(data.pcaRaw$x[,1])-min(data.pcaRaw$x[,1]))/100),
       t(data.pcaRaw$x[,2]), rownames(data.pcaRaw$x), col=listByGroup, font=3, cex=1)
  devOff() 
  
  #PCAbest <- paste("picts/PCABest", tkn, ".png", sep="")
  png(PCAbest)
  mostSig <- plist[1]
  nextSig <- plist[2]
  
  plot(t(data.pcaRaw$x[,mostSig]), t(data.pcaRaw$x[,nextSig]), col=listByGroup, pch=16, xlab=paste("PC",mostSig), ylab = paste("PC",nextSig), main=paste("PCA best dataset (PC", mostSig, " by PC", nextSig, ") ", tkn), font=3, cex=2)
  text(t(data.pcaRaw$x[,mostSig])+abs((max(data.pcaRaw$x[,mostSig])-min(data.pcaRaw$x[,mostSig]))/100),
       t(data.pcaRaw$x[,nextSig]), rownames(data.pcaRaw$x), col=listByGroup, font=3, cex=1)
  devOff() 
  
  #FigPCAScreePlot <- paste("picts/PCAScreePlot", tkn, ".png", sep="")
  png(PCAscree)
  plot(data.pca, main=paste("PCA scree plot (1:",snum, ") ", tkn), type="lines", pch=20, col = "black", font=3) #, bty="o")
  devOff()
  
  FigPCA <- paste("picts/PCA", tkn, ".png", sep="")
  png(FigPCA)
  plot(t(data.pca$x[,1]), t(data.pca$x[,2]), col=listByGroup, pch=16, xlab="PC1", ylab = "PC2", main=paste("PCA Pruned dataset (PC1 by PC2) ", tkn), font=3, cex=2)
  text(t(data.pca$x[,1])+abs((max(data.pca$x[,1])-min(data.pca$x[,1]))/100), t(data.pca$x[,2]),
       rownames(data.pca$x), col=listByGroup, font=3, cex=1)
  devOff() 
  
  FigPCAAll <- paste("picts/PCAAll", tkn, ".png", sep="")
  png(FigPCAAll)
  grpplot(data.pca$x[,1:5], deSign[,3], pch=15:25, cex=1.3, main=paste("Group PC by PC", tkn, sep="") )
  devOff()
  
  FigPCLoadings <- paste("picts/PCLoadings", tkn, ".png", sep="")
  png(FigPCLoadings)
  biplot(data.pca, col="blue", main="PCA loadings Plot")
  devOff()
  
  FigPCARotations <- paste("picts/PCARotations", tkn, ".png", sep="")
  png("picts/PCARotations.png")
  plot(x=data.pca$rotation[,1], y=data.pca$rotation[,2], pch=20, xlab="PC1", ylab = "PC2", main="PCA: PC1xPC2 compounds plot")
  devOff()
  
  FigPCA1Xsamp <- paste("picts/PCA1Xsamp", tkn, ".png", sep="")
  png(FigPCA1Xsamp)
  plot(data.pca$x[,1], col=listByGroup, main="PCA (PC1 by sample)", pch=16, font=3) #, bty="o")
  devOff()
  
  FigPCA2Xsamp <- paste("picts/PCA2Xsamp", tkn, ".png", sep="")
  png(FigPCA2Xsamp)
  plot(data.pca$x[,2], col=listByGroup, main="PCA (PC2 by sample)", pch=16, font=3) #, bty="o")
  devOff()
  
  FigPCARecast <- paste("picts/PCARecast", tkn, ".png", sep="")
  png(FigPCARecast, 1000, 1000)  # recast matrix
  heatmap.2(data.matrix(data.pca.recast), Rowv=F, Colv=F, col="heat.colors", cexRow=3, cexCol=2,
            scale="column", margins=c(5,10), main=paste("PCA (recast data - PC1:PC", snum, ")"), 
            key=T, keysize=.5, dendrogram="none", trace="none", font=3, labCol="")
  devOff()
  # -------------------------------end plot/pca 
  
  #sheetPCA <- fill PCA tab
  addWorksheet(wb, "PCA") # , sheetName="MNorm")
  
  Stamp <- as.data.frame(paste("This tab shows results from PCA analyses on the two RF datasets."))
  writeData(wb, "PCA", Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
  
  writeData(wb, "PCA", pcaSummary, startRow=3, startCol=1, rowNames=T, colNames=T)
  addStyle(wb, "PCA", style=createStyle(numFmt="0.00%"),    rows=1:14, cols = 2,   gridExpand = T,  stack = T )
  addStyle(wb, "PCA", style=createStyle(numFmt="0.00E+00"), rows=1:14, cols = 3:5, gridExpand = T,  stack = T )
  negStyle <- createStyle(bgFill = "yellow")
  conditionalFormatting(wb, "PCA",  rule = "<0.0001", style=negStyle, cols=4:5, rows=3:13)
  
   junk <- as.matrix(lookup[rownames(RFList[[ListNum]]$RFnames2),2])
   colnames(junk)[1] <- "Name"
 
   writeData(wb, "PCA", as.matrix(data.pca$rotation[,1:5]), startRow=17, startCol=2, colNames=T, rowNames=T)
   addStyle(wb, "PCA", style=createStyle(numFmt="0.00E+00"), rows=1:nrow(data.pca$rotation), cols = 3:7, gridExpand = T,  stack = T )
   
   writeData(wb, "PCA", as.matrix(data.pca$x[,1:5]), startRow=17, startCol=9, colNames=T, rowNames=T)
   addStyle(wb, "PCA", style=createStyle(numFmt="0.00E+00"), rows=1:nrow(data.pca$rotation), cols = 10:17, gridExpand = T,  stack = T )
   
   #writeData(wb, "PCA", pcaPScores, startRow=17, startCol=16, colNames=T, rowNames=T)

   insertImage(wb, "PCA", PCAraw, width=2, height=2, startRow=2, startCol=7 )
   insertImage(wb, "PCA", FigPCA, width=2, height=2, startRow=2, startCol=10 )
   insertImage(wb, "PCA", PCAbest, width=2, height=2, startRow=2, startCol=13 )   
   insertImage(wb, "PCA", FigPCLoadings, width=2, height=2, startRow=2, startCol=16 )
   insertImage(wb, "PCA", FigPCAAll, width=2, height=2, startRow=2, startCol=20 )
   insertImage(wb, "PCA", PCAscree, width=2, height=2, startRow=17, startCol=16 )
   insertImage(wb, "PCA", "picts/legend.png", width=4, height=4, startRow=27, startCol=16 )
   
   # saveWorkbook(wb, "reports/RR_TEST.xlsx", overwrite = T )  # for debug
      
   PCAretlist <- list(
     PCARaw = data.pcaRaw,
     pcaTOP1  = data.PCATop1,
     pcaSummary  = pcaSummary 
     ) # end list
   
   return(PCAretlist) # end of return
   
}   # end of function PCATab

SOMTAB <- function(Din) {
 
  data.som <- scale(Din)
  snum <- floor(sqrt(length(rownames(DATA))))
  data.som.out <- som(data.som, grid=somgrid(snum, snum, "rectangular"), rlen=1000, keep.data=TRUE )
  data.tsom.out <- som(t(data.som), grid=somgrid(5,5, "rectangular"), rlen= 1000, keep.data=TRUE )
  
  # somCodes <- as.data.frame(data.tsom.out$codes)
  # for(i in 1:max(data.tsom.out$unit)){
  #   names <- rownames(as.data.frame(data.tsom.out$data))[data.tsom.out$unit.classif==i]
  #   somcode <- somCodes[i,]
  #   somset <- DATA[,names]
  #   increment <- ( max(somcode)-min(somcode))/length(names)
  #   
  #   pname <- paste("picts/som_", i, ".png", sep="")
  #   png(pname, 2000,2000)
  #   
  #   par(mar=c(2,2,2,2))
  #   par(mfrow=c(1,2), mar=c(3,2,1.5,.5), oma = c(0.5,0.5,3,0))
  #   
  #   if(length(names)>1){
  #     plot(somcode, col=listByGroup, pch=16, cex=4)
  #     
  #     for(a in 1:length(names)){ text(2, min(somcode)+(a*increment), names[a], cex=2) }
  #     
  #     plot(somset[,1], xlim=range(1:length(somset[,1])), ylim=range(0,max(somset)), col=listByGroup, type="o", pch=20, cex=2, ylab=NA, xlab=NA)
  #     
  #     for(b in 1:length(names)) {
  #       points(somset[,b], col=listByGroup, type="o", pch=20, cex=2, ylab=NA, xlab=NA)
  #     }
  #     for(b in 1:length(names)) {
  #       lines(somset[,b], col="grey20", type="o", pch=20, lty=b)
  #       text(2, max(somset[,b]), names[b])
  #     }
  #   }
  #   
  #   if(length(names)==1) {
  #     plot(somcode, col=listByGroup, pch=16, cex=4)
  #     plot(somset, col=listByGroup, type="o", pch=20, cex=2, ylab=NA, xlab=NA)
  #   }
  #   
  #   if(length(names)<1) {
  #     plot(somcode, col=listByGroup, pch=16, cex=4)
  #     plot(1)
  #   }
  #   
  #   mtext(paste("There are ", length(names), " compounds like this"), outer=TRUE, cex=2)
  #   
  #   devOff()
  # }
  # rm(somCodes)
  
  # -------- end analysis/som ------ start plot/som
  
  # # duplicated from analysis/som
  # data.som <- scale(data.RFTop1)
  # snum <- floor(sqrt(length(rownames(DATA))))
  # data.som.out <- som(data.som, grid=somgrid(snum, snum, "rectangular"), rlen=1000, keep.data=TRUE )
  # data.tsom.out <- som(t(data.som), grid=somgrid(5,5, "rectangular"), rlen= 1000, keep.data=TRUE )
  # 
  # generate picts
  png("picts/SOMSamples1.png")
  plot(data.som.out, main="SOM Pattern - Samples", keepMargins=TRUE)
  devOff()
  
  png("picts/SOMSamples2.png")
  plot(data.som.out, type="mapping", labels=rownames(data.som), col=listByGroup, main="SOM mapping plot - Samples")
  devOff()
  
  png("picts/SOMCmpds1.png")
  #plot(data.tsom.out, col=listByGroup, main="Som Pattern - Compounds", contin=F)
  plot(data.tsom.out, col=listByGroup, main="Som Pattern - Compounds")
  devOff()
  
  png("picts/SOMCmpds2.png", 1000, 1000)
  plot(data.tsom.out, type="mapping", labels=colnames(data.som), col="black", cex=0.7, main="SOM mapping plot - Top Compounds")
  devOff()
  # -----------  end plot/som  ----- fill the SOM tab
 
  
   #sheetSO <-sheets[[10]]
   addWorksheet(wb, "SOM") # , sheetName="MNorm")
   
   Stamp <- as.data.frame(paste("This tab show the output from a SOM analysis"))
   writeData(wb, "SOM", Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
   
   insertImage(wb, "SOM", "picts/SOMSamples1.png", width=3, height=3, startRow=3, startCol=3 )
   #   addPicture("picts/SOMSamples1.png", sheetSO, scale=.5, startRow=4, startColumn=3 )
   
   insertImage(wb, "SOM", "picts/SOMCmpds1.png", width=3, height=3, startRow=19, startCol=3 )
   # addPicture("picts/SOMCmpds1.png", sheetSO, scale=.5, startRow=17, startColumn=3 )
   
   insertImage(wb, "SOM", "picts/SOMSamples2.png", width=3, height=3, startRow=3, startCol=7 )
   #  addPicture("picts/SOMSamples2.png", sheetSO, scale=.5, startRow=4, startColumn=8 )
   
   insertImage(wb, "SOM", "picts/SOMCmpds2.png", width=3, height=3, startRow=19, startCol= 7 )
   #  addPicture("picts/SOMCmpds2.png", sheetSO, scale=.25, startRow=17, startColumn=8 )
  
  # for(i in 0:4){
  #   for(j in 1:5){
  #     num <- (5*i)+j
  #     addPicture(paste("picts/som_", num, ".png", sep=''), sheetSO, scale=.1, startRow=4+(i*5), startColumn=13+((j-1)*2) )
  #   }  
  # } # end picture addition
}   # end of function SomTab

NMFTabs <- function(Din, knum, set){
  ### NMF script 
  #   wb <- createWorkbook()   # for debug
  #   Din <- data.pTop1       # for debug
  #   knum <- length(groups)                #  for debug
  #   set <- "test1"  
  
  numCond <- length(conditions)
  NMFAnova <- as.matrix(1:(knum-1))
  NMFAnova[] <- 2
  rownames(NMFAnova) <- c(2:(knum) ) 
  allNMF <- TRUE
  Din[Din==-1] <- 0  # to correct for the -1 which indicates neither IS nor NA seen)
  
  # run NMF on K passed as arg to function
    nmf_result  <-  nmf(Din, knum, seed="random" )
    
    # Begin basis analysis
    basis <- basis(nmf_result)
    colnames(basis) <- colnames(basis, do.NULL=FALSE, prefix=paste("nmf",knum,"-"))
    vRange <- range(0, basis(nmf_result))
    
    # calculate P values for basis
    nmfPScores <- as.matrix(1:ncol(basis))
    rownames(nmfPScores) <- colnames(basis)
    colnames(nmfPScores)[1] <- "p value"
    
    for (i in 1:(ncol(basis))){
      name <- colnames(basis)[i]
      lmodel <- lm(basis[,i] ~ deSign[,3], data=as.data.frame(basis) )
      Result <- anova(lmodel)
      nmfPScores[i] <- Result$P[1]
    }  

    avgPScore <- as.data.frame(sum(nmfPScores)/3, row.names="Average")
    NMFAnova[knum-1] <- avgPScore # store it but not sure I ever use it from here
    
    plist <- order(nmfPScores, decreasing=F)
    
    colBasis <- rownames(basis)
    plus <- deSign[colBasis,c(3,4)]
    basisPlus <- cbind(plus, basis)
    
    basisPlus <- basisPlus[order( basisPlus$ExperimentalGroup),]
    
    ##------------Analysis of Basis for table
    
    #groups <- c("GroupA", "GroupB", "GroupC")  # original RR group
    #groups <- levels(deSign$GroupFactor)
    NMFStats <- as.data.frame(matrix(nrow=length(groups), ncol=4), stringsAsFactors=F)
    rownames(NMFStats) <- groups
    colnames(NMFStats) <- c("Column", "S/N", "Observed", "expected")
    NMFStats[] <- 0
    
    for(grp in groups) {
      #Test1 <- as.data.frame(basisPlus[basisPlus$ExperimentalGroup == grp, c(2)] ) # get all concentrations
      Test1 <- as.data.frame(basisPlus[basisPlus$ExperimentalGroup == grp, c(3,4)] ) # get all concentrations
      eRSD <- percent(sd(Test1[,1])/mean(Test1[,1]), digits=2)                    # calculate expected %RSD 
      #print(Test1)
      
      Test2 <- as.data.frame(basisPlus[basisPlus$ExperimentalGroup == grp,c(3:4)] )
      TestColSums <- as.data.frame( sort(colSums(Test2[]), decreasing=TRUE))
      grpMatch <- rownames(TestColSums)[1]
      S2N <- TestColSums[1,]/ ((TestColSums[2,]+TestColSums[3,])/2)
      AMean <- mean(Test2[,grpMatch])
      ASDev <- sd(Test2[,grpMatch])
      RSD <- percent(ASDev/AMean, digits=2)
      
      NMFStats[grp,1] <- grpMatch
      NMFStats[grp,2] <- S2N
      NMFStats[grp,3] <- RSD
      NMFStats[grp,4] <- eRSD
      
      GrpID <- paste( grp, " is associated with ", grpMatch, " and has an %RSD of ", RSD,". The sample RSD was ", eRSD, sep="")
    }   #  end basis analysis
    
    # Begin Coefficient analysis
    cutOFF <- 0.60
    coef <- coef(nmf_result)  
    rownames(coef) <- colnames(basis)
    scaledCoef <<- t(scale(coef, center = F, scale = colSums(coef)))
    
    colcoef <- colnames(coef)
    plus <- lookup[colcoef,c(1,2,4,5,6)]       # build subset of Lookup
   
    LabNum <- as.data.frame(scaledCoef[,1])    # add labnum to Coef
    colnames(LabNum) <- c("LabNum")
    LabNum[,1] <- c(tkn)
    
    Trans <- as.data.frame(scaledCoef[,1])     # Make column to accept biomarker notation
    colnames(Trans) <- c("Group")
    Trans[,] <- ""
    
    for(i in 1:nrow(scaledCoef)) {             # for each row determine which column is max   
      test1 <- as.data.frame(sort(scaledCoef[i,], decreasing=TRUE)) # isolate row and sort
      binID <- rownames(scaledCoef)[i]                              # what is the BinID of this row
      
      if(max(test1)>cutOFF) {                                       # Are any values > cutoff (as long as this is greater than 50% there can only be 1)
        rname <- rownames(test1)[1]                                 # if so which column
        col <- rownames(NMFStats[NMFStats$Column==rname,])             # which experimental condition is this
        if(length(col)!=1) { col <- "NotClr" }
        } else { col <- "-" }                                       # if not put in a dash
      
      Trans[i,1] <- col                                             # put this value in Trans
      }
    
    scaledCoefPlus <- cbind(LabNum, plus, scaledCoef, Trans)  # final form for report
    
    ####  top_cmpds <- cbind(cmpds, RF2topCMPDS, scaledCoef)
    numFact <- as.numeric(length(unique(deSign[,3])))
    hc <- hclust(as.dist(1-cor(t(basis(nmf_result)), method="pearson")), method="complete")            
    mycl <- cutree(hc, numFact)
    mycol <- sample(rainbow(256)) 
    mycol <- mycol[as.vector(mycl)]
    
    # # analyze top compounds in Coef by factor level
    # topNMF <<- data.frame(1:nrow(deSign))
    # rownames(topNMF) <-rownames(deSign)
    # topNMF <<- topNMF[,-1:-ncol(topNMF)]

    #  This new route to topPredictors is faster and better
    NMFSort <- as.data.frame(scaledCoef)
    colnames(NMFSort) <- paste0(rep("a"), rep(1:knum))
    
    topPredictors <- NMFSort[NMFSort$a1>cutOFF,]  
    
    for(c in 2:knum) { topPredictors <- rbind(topPredictors, NMFSort[c >cutOFF,]) }
    # tempPredictors1 <- NMFSort[NMFSort$a1>cutOFF,]  
    # tempPredictors2 <- NMFSort[NMFSort$a2 >cutOFF,]
    # tempPredictors3 <- NMFSort[NMFSort$a3 >cutOFF,]
    # 
    # temp2Predictors <- rbind(tempPredictors1, tempPredictors2, tempPredictors3)
    topCmpds <- rownames(topPredictors)
    # data.NMFTop1 <- DATA[,topCmpds ]  #  need to fix moving on due to short time

  # Generate picts and stuff NMF tab.
    
    png(paste("picts/NMFSamples",knum,".png", sep=""), 1000, 800)
    plot(0,0, xlim=c(1,length(rownames(DATA))), 
      ylim=vRange, ylab="nmf basis", xlab="sample number",  type="n", 
      main=paste("NMF (k=",knum,") basis plot", tkn, sep=""), cex.main=3 )
    for(b in 1:knum) {
      lines(basis[,b], col="grey20", type="o", pch=20, lty=b, lwd=2)
      points(basis[,b], col=listByGroup, pch=20, cex=2)
    }
    devOff()
    
    png(paste("picts/NMFSampTower", knum, ".png", sep=""), 1000, 1000)      
    par(mfrow=c(knum,1))
    for(b in 1:knum) { 
      plot(basis[,b], col=listByGroup, type="o", pch=20, cex=2, 
      ylim=vRange, ylab="basis", xlab=NA)
      lines(basis[,b], col="grey20", type="o", pch=20, lty=b)
    }
    devOff()
    
    png(paste("picts/NMFALLPlot", knum, ".png", sep=""), 1000, 800)
    grpplot(basis[,1:knum], deSign[,3], pch=15:25, cex=3,  main=paste("NMF K=",knum, " group comparisons ", tkn, sep=""), cex.main=3)
    devOff() 
    
    hold <- par()
    par(mar=c(5, 20, 5, 10), oma=c(5,20,4,10))
    png(paste("picts/NMFHeatMap",knum,".png", sep=""), 1000, 800)
    basismap(nmf_result, subsetRow=F, )
    devOff() 
    par <- hold
    
    # recalculate matrix (but using scaledCoef)
    level <- as.matrix(basis %*% coef)
    png(paste("picts/NMFrecastHeatMap",knum,".png", sep=""), 2000, 1600)  
    heatmap.2(level, col="heat.colors", scale="column", margins=c(5,10), 
              main=paste("NMF Recast Heatmap ( k=", knum, " ) ", tkn, sep=""), cexRow=3, cexCol=2,
              key=T, keysize=.5, dendrogram="none", Rowv=T, Colv=F, trace="none", labCol="", cex.main=3)
    devOff()
    
    # if(k>2) because we only have two dimensions 
      png(NMFbest, 1000, 800)
      mostSig <- plist[1]
      nextSig <- plist[2]
      plot(basis[,mostSig], basis[,nextSig], col=listByGroup, pch=16, cex=4,  
           xlab=paste("NMF ", knum, "-",mostSig), ylab = paste("NMF ", knum, "-",nextSig), 
           main=paste("NMF", knum, " (NMF ", knum, "-", mostSig, " by NMF ", knum, "-", nextSig, ") ", tkn), font=3, cex.main=3)
      text(basis[,mostSig], basis[,nextSig], rownames(basis), col=listByGroup, cex=2)
      devOff() 
  
     #lowest <- NMFAnova[which.min(NMFAnova)]*2 
     lowest <- 0.5 # normally set to <0.05
  
  #  -------------------------------end analysis/NMF -- Now build page
  
  
  if(knum==2) {
    BotCmpd = nrow(scaledCoef)+16
    BotBasis = nrow(basisPlus)+16
    CW = ncol(scaledCoefPlus)+2
    BW = CW +ncol(basisPlus)+2
    
    # prep done create tab and arrange
    if(set=="NMF2(full)"){sheet2 <- "NMF2(full DATA)"} else {sheet2 <- paste(set, "->", "NMF", knum, sep="")}
    addWorksheet(wb, sheet2) 
    
    Stamp <- as.data.frame(paste("This tab has the report for mode = ", mode, " k=", knum))
    writeData(wb, sheet2, Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
    
    writeData(wb, sheet2, scaledCoefPlus, startRow=15, startCol=1, colNames=T, rowNames=F)
    setColWidths(wb, sheet2, cols=1:3, widths = 22)
    addStyle(wb, sheet2, style=createStyle(numFmt="0.0000"), rows=1:BotCmpd, cols = 5, gridExpand=T, stack=T )
    addStyle(wb, sheet2, style=createStyle(numFmt="0.00"), rows=1:BotCmpd, cols = 6, gridExpand=T, stack=T )
    addStyle(wb, sheet2, style=createStyle(numFmt="0.0%"), rows=1:BotCmpd, cols = 7:8, gridExpand=T, stack=T )
    negStyle <- createStyle(bgFill = "yellow")
    conditionalFormatting(wb, sheet2,  rule = paste(">",cutOFF, sep=""), style=negStyle, rows=16:BotCmpd, cols=7:8)
    
    writeData(wb, sheet2, basisPlus, startRow=15, startCol=CW, rowNames=T, colNames=T)
    #addStyle(wb, sheet2, style=createStyle(numFmt="0.00"), rows=1:BotBasis, cols = c(14), gridExpand=T, stack=T ) 
    addStyle(wb, sheet2, style=createStyle(numFmt="0.00E+00"), rows=1:BotBasis, cols = c(14:15), gridExpand = T, stack = T )
    conditionalFormatting(wb, sheet2,  type="colourScale", style=c("red1","yellow", "green"), cols=14:15, rows=1:BotBasis)
    
    BasisStamp2 <- paste("The above and below tables are different analyses of the basis table to the left.", sep="")
    writeData(wb, sheet2, nmfPScores, startRow=15, startCol=BW, colNames=T, rowNames=T)
    writeData(wb, sheet2, avgPScore , startRow=20, startCol=BW, colNames=F, rowNames=T)
    writeData(wb, sheet2, BasisStamp2, startRow=23, startCol=BW, colNames=F, rowNames=F)
    writeData(wb, sheet2, NMFStats  , startRow=25, startCol=BW, colNames=T, rowNames=T)
    
    insertImage(wb, sheet2, "picts/NMFHeatMap2.png", width=2, height=2, startRow=3, startCol=3 )
    insertImage(wb, sheet2, NMFbest, width=2, height=2, startRow=3, startCol=6 )
    insertImage(wb, sheet2, "picts/NMFALLPlot2.png", width=2, height=2, startRow=3, startCol=9 )
    insertImage(wb, sheet2, "picts/NMFSamples2.png", width=2, height=2, startRow=3, startCol=12 )
    insertImage(wb, sheet2, "picts/NMFrecastHeatMap2.png", width=2, height=2, startRow=3, startCol=15 )
    
    insertImage(wb, sheet2, "picts/legend.png", width=2, height=2, startRow=3, startCol=21 )
    
    # saveWorkbook(wb, paste("reports/RR_TEST.xlsx", sep=""), overwrite = T ) # for debug
    
  }  # end if(k==2)
  
  if(knum==3) {
    
    BotCmpd = nrow(scaledCoef)+16
    BotBasis = nrow(basisPlus)+16
    
    # prep done create tab and arrange
  
  if(set=="NMF3(full)"){sheet <- "NMF3 (full DATA)"} else {sheet <- paste(set, "->", "NMF3", sep="")}
  addWorksheet(wb, sheet) 
  
  Stamp <- as.data.frame(paste("This tab has the report for k=", knum))
  writeData(wb, sheet, Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
  
  writeData(wb, sheet, scaledCoefPlus, startRow=15, startCol=1, colNames=T, rowNames=F)
    setColWidths(wb, sheet, cols=1:3, widths = 22)
    addStyle(wb, sheet, style=createStyle(numFmt="0.0000"), rows=1:BotCmpd, cols = 5, gridExpand=T, stack=T )
    addStyle(wb, sheet, style=createStyle(numFmt="0.00"), rows=1:BotCmpd, cols = 6, gridExpand=T, stack=T )
    addStyle(wb, sheet, style=createStyle(numFmt="0.0%"), rows=1:BotCmpd, cols = 7:9, gridExpand=T, stack=T )
    negStyle <- createStyle(bgFill = "yellow")
    conditionalFormatting(wb, sheet,  rule = paste(">",cutOFF, sep=""), style=negStyle, rows=16:BotCmpd, cols=7:9)
  
  writeData(wb, sheet, basisPlus, startRow=15, startCol=12, rowNames=T, colNames=T)
    addStyle(wb, sheet, style=createStyle(numFmt="0.00"), rows=1:47, cols = c(14,21), gridExpand=T, stack=T )
    addStyle(wb, sheet, style=createStyle(numFmt="0.00E+00"), rows=1:47, cols = c(15:17,20), gridExpand = T, stack = T )
    conditionalFormatting(wb, sheet,  type="colourScale", style=c("red1","yellow", "green"), cols=15:17, rows=1:BotBasis)
  
  BasisStamp2 <- paste("The above and below tables are different analyses of the basis table to the left.", sep="")
  writeData(wb, sheet, nmfPScores, startRow=15, startCol=19, colNames=T, rowNames=T)
  writeData(wb, sheet, avgPScore , startRow=20, startCol=19, colNames=F, rowNames=T)
  writeData(wb, sheet, BasisStamp2, startRow=23, startCol=19, colNames=F, rowNames=F)
  writeData(wb, sheet, NMFStats  , startRow=25, startCol=19, colNames=T, rowNames=T)
  
  insertImage(wb, sheet, "picts/NMFHeatMap3.png", width=2, height=2, startRow=3, startCol=3 )
  insertImage(wb, sheet, NMFbest, width=2, height=2, startRow=3, startCol=6 )
  insertImage(wb, sheet, "picts/NMFALLPlot3.png", width=2, height=2, startRow=3, startCol=9 )
  insertImage(wb, sheet, "picts/NMFSamples3.png", width=2, height=2, startRow=3, startCol=12 )
  insertImage(wb, sheet, "picts/NMFrecastHeatMap3.png", width=2, height=2, startRow=3, startCol=15 )
  
  insertImage(wb, sheet, "picts/legend.png", width=4, height=4, startRow=3, startCol=21 )
  
  # saveWorkbook(wb, paste("reports/RR_TEST.xlsx", sep=""), overwrite = T ) # for debug
  
  # ---------------------Update AllScores
  #if(as.numeric(sum(NMFPScores3)/3)<.05) {AllScores["NMF3",colnames(data.NMFTop3)] <- 1}  else {AllScores <- AllScores[!rownames(AllScores) %in% "NMF3",]}
  
  }  # end if(k==3)
  
  if(knum==4) {
    
    avg4 <- as.data.frame(sum(NMFPScores4)/4, row.names="Average")
    NMFCmpds4Tmp <- as.data.frame(cbind(as.matrix(lookup[rownames(NMFCmpds4),2]), (lookup[rownames(NMFCmpds2),4]), (lookup[rownames(NMFCmpds2),6:7]), NMFCmpds4))
    colnames(NMFCmpds4Tmp)[1:2] <- c("Name","MF")
    NMFSmpls4Tmp <- as.data.frame(cbind(as.data.frame(deSign[,3]), NMFSmpls4))
    NMFPScores4Tmp <- as.data.frame(NMFPScores4[,])
    
    if(as.numeric(sum(NMFPScores4)/4)<.05) {AllScores["NMF4",colnames(data.NMFTop4)] <- 1}  else {AllScores <- AllScores[!rownames(AllScores) %in% "NMF4",]}
    
    
    write.table(lookup[NMFTopCmpds4[NMFTopCmpds4$NMF.Level=="NMF4-1 Cluster",1],3], file="concept/NMF4-1.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds4[NMFTopCmpds4$NMF.Level=="NMF4-2 Cluster",1],3], file="concept/NMF4-2.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds4[NMFTopCmpds4$NMF.Level=="NMF4-3 Cluster",1],3], file="concept/NMF4-3.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds4[NMFTopCmpds4$NMF.Level=="NMF4-4 Cluster",1],3], file="concept/NMF4-4.txt", row.names=F, col.names = c("CID") )
    

  # #sheetN4 <- createSheet(wb, sheetName = paste("NMF4"))
  sheetN4 <- sheets[[13]]
  
  #addDataFrame(junk, sheetN4, startRow=15, startColumn=1, col.names=T, row.names=F)
  addDataFrame(NMFCmpds4Tmp, sheetN4, startRow=15, startColumn=1, col.names=T, row.names=T)
  addDataFrame(NMFSmpls4Tmp, sheetN4, startRow=15, startColumn=length(NMFCmpds4Tmp)+3, col.names=T, row.names=T)
  addDataFrame(NMFPScores4, sheetN4, startRow=15, startColumn=length(NMFCmpds4Tmp)+length(NMFSmpls4Tmp)+5, col.names=T, row.names=T)
  addDataFrame(avg4, sheetN4, startRow=21, startColumn=length(NMFCmpds4Tmp)+length(NMFSmpls4Tmp)+5, col.names=F, row.names=T)
  addDataFrame(NMFplist4, sheetN4, startRow=23, startColumn=length(NMFCmpds4Tmp)+length(NMFSmpls4Tmp)+6, col.names=F, row.names=F)
  
  addPicture(paste("picts/NMFHeatMap4.png"), sheetN4, scale=.3, startRow=2, startColumn=3 )
  addPicture(paste("picts/NMFALLPlot4.png"), sheetN4, scale=.3, startRow=2, startColumn=9 )
  addPicture(paste("picts/NMFSamples4.png"), sheetN4, scale=.3, startRow=2, startColumn=15 )
  addPicture(paste("picts/NMFrecastHeatMap4.png"), sheetN4, scale=.3, startRow=2, startColumn=20 )
  addPicture(paste("picts/NMFAvgPPlot.png"), sheetN4, scale=.4, startRow=2, startColumn=25 )
  
  # addPicture(paste("picts/NMF4-1Cluster.png"), sheetN4, scale=.15, startRow=15, startColumn=22 )
  # addPicture(paste("picts/NMF4-1Correlation.png"), sheetN4, scale=.15, startRow=15, startColumn=25 )
  # addPicture(paste("picts/NMF4-1CorGaussian.png"), sheetN4, scale=.15, startRow=15, startColumn=28 )
  # addPicture(paste("picts/NMF4-1Gaussian.png"), sheetN4, scale=.15, startRow=15, startColumn=31 )
  # 
  # addPicture(paste("picts/NMF4-2Cluster.png"), sheetN4, scale=.15, startRow=22, startColumn=22 )
  # addPicture(paste("picts/NMF4-2Correlation.png"), sheetN4, scale=.15, startRow=22, startColumn=25 )
  # addPicture(paste("picts/NMF4-2CorGaussian.png"), sheetN4, scale=.15, startRow=22, startColumn=28 )
  # addPicture(paste("picts/NMF4-2Gaussian.png"), sheetN4, scale=.15, startRow=22, startColumn=31 )
  # 
  # addPicture(paste("picts/NMF4-3Cluster.png"), sheetN4, scale=.15, startRow=29, startColumn=22 )
  # addPicture(paste("picts/NMF4-3Correlation.png"), sheetN4, scale=.15, startRow=29, startColumn=25 )
  # addPicture(paste("picts/NMF4-3CorGaussian.png"), sheetN4, scale=.15, startRow=29, startColumn=28 )
  # addPicture(paste("picts/NMF4-3Gaussian.png"), sheetN4, scale=.15, startRow=29, startColumn=31 )
  # 
  # addPicture(paste("picts/NMF4-4Cluster.png"), sheetN4, scale=.15, startRow=36, startColumn=22 )
  # addPicture(paste("picts/NMF4-4Correlation.png"), sheetN4, scale=.15, startRow=36, startColumn=25 )
  # addPicture(paste("picts/NMF4-4CorGaussian.png"), sheetN4, scale=.15, startRow=36, startColumn=28 )
  # addPicture(paste("picts/NMF4-4Gaussian.png"), sheetN4, scale=.15, startRow=36, startColumn=31 )
  # 
  # addPicture(paste("picts/NMF4-AllCluster.png"), sheetN4, scale=.15, startRow=43, startColumn=22 )
  # addPicture(paste("picts/NMF4-AllCorrelation.png"), sheetN4, scale=.15, startRow=43, startColumn=25 )
  # addPicture(paste("picts/NMF4-AllCorGaussian.png"), sheetN4, scale=.15, startRow=43, startColumn=28 )
  # addPicture(paste("picts/NMF4-AllGaussian.png"), sheetN4, scale=.15, startRow=43, startColumn=31 )
  
  addPicture(paste("picts/NMF1by2Plot4.png"), sheetN4, scale=.3, startRow=52, startColumn=22 )
  addPicture(paste("picts/NMF1by3Plot4.png"), sheetN4, scale=.3, startRow=52, startColumn=27 )
  gc()
  
  }  # end if(k==4)
  
  if(knum==5) {
  
  # not sure where but AllScores needs to be updated    
  if(as.numeric(sum(NMFPScores6)/6)<.05) {AllScores["NMF6",colnames(data.NMFTop6)] <- 1}  else {AllScores <- AllScores[!rownames(AllScores) %in% "NMF6",]}
    
  avg5 <- as.data.frame(sum(NMFPScores5)/5, row.names="Average")
  NMFCmpds5Tmp <- as.data.frame(cbind(as.matrix(lookup[rownames(NMFCmpds5),2]), (lookup[rownames(NMFCmpds2),4]), (lookup[rownames(NMFCmpds2),6:7]), NMFCmpds5))
  colnames(NMFCmpds5Tmp)[1:2] <- c("Name","MF")
  NMFSmpls5Tmp <- as.data.frame(cbind(as.data.frame(deSign[,3]), NMFSmpls5))
  NMFPScores5Tmp <- as.data.frame(NMFPScores5[,])
  
  if(as.numeric(sum(NMFPScores5)/5)<.05) {AllScores["NMF5",colnames(data.NMFTop5)] <- 1}  else {AllScores <- AllScores[!rownames(AllScores) %in% "NMF5",]}
  
  write.table(lookup[NMFTopCmpds5[NMFTopCmpds5$NMF.Level=="NMF5-1 Cluster",1],3], file="concept/NMF5-1.txt", row.names=F, col.names = c("CID") )
  write.table(lookup[NMFTopCmpds5[NMFTopCmpds5$NMF.Level=="NMF5-2 Cluster",1],3], file="concept/NMF5-2.txt", row.names=F, col.names = c("CID") )
  write.table(lookup[NMFTopCmpds5[NMFTopCmpds5$NMF.Level=="NMF5-3 Cluster",1],3], file="concept/NMF5-3.txt", row.names=F, col.names = c("CID") )
  write.table(lookup[NMFTopCmpds5[NMFTopCmpds5$NMF.Level=="NMF5-4 Cluster",1],3], file="concept/NMF5-4.txt", row.names=F, col.names = c("CID") )
  write.table(lookup[NMFTopCmpds5[NMFTopCmpds5$NMF.Level=="NMF5-5 Cluster",1],3], file="concept/NMF5-5.txt", row.names=F, col.names = c("CID") )
  
    #sheetN5 <- createSheet(wb, sheetName = paste("NMF5"))
  sheetN5 <- sheets[[14]]
  
  #addDataFrame(junk, sheetN5, startRow=15, startColumn=1, col.names=T, row.names=F)
  addDataFrame(NMFCmpds5Tmp, sheetN5, startRow=15, startColumn=1, col.names=T, row.names=T)
  addDataFrame(NMFSmpls5Tmp, sheetN5, startRow=15, startColumn=length(NMFCmpds5Tmp)+3, col.names=T, row.names=T)
  addDataFrame(NMFPScores5, sheetN5, startRow=15, startColumn=length(NMFCmpds5Tmp)+length(NMFSmpls5Tmp)+5, col.names=T, row.names=T)
  addDataFrame(avg5, sheetN5, startRow=22, startColumn=length(NMFCmpds5Tmp)+length(NMFSmpls5Tmp)+5, col.names=F, row.names=T)
  addDataFrame(NMFplist5, sheetN5, startRow=24, startColumn=length(NMFCmpds5Tmp)+length(NMFSmpls5Tmp)+6, col.names=F, row.names=F)
  
  addPicture(paste("picts/NMFHeatMap5.png"), sheetN5, scale=.3, startRow=2, startColumn=3 )
  addPicture(paste("picts/NMFALLPlot5.png"), sheetN5, scale=.3, startRow=2, startColumn=9 )
  addPicture(paste("picts/NMFSamples5.png"), sheetN5, scale=.3, startRow=2, startColumn=15 )
  addPicture(paste("picts/NMFrecastHeatMap5.png"), sheetN5, scale=.3, startRow=2, startColumn=20 )
  addPicture(paste("picts/NMFAvgPPlot.png"), sheetN5, scale=.4, startRow=2, startColumn=25 )
  
  # addPicture(paste("picts/NMF5-1Cluster.png"), sheetN5, scale=.15, startRow=15, startColumn=24 )
  # addPicture(paste("picts/NMF5-1Correlation.png"), sheetN5, scale=.15, startRow=15, startColumn=27 )
  # addPicture(paste("picts/NMF5-1CorGaussian.png"), sheetN5, scale=.15, startRow=15, startColumn=30 )
  # addPicture(paste("picts/NMF5-1Gaussian.png"), sheetN5, scale=.15, startRow=15, startColumn=33 )
  # 
  # addPicture(paste("picts/NMF5-2Cluster.png"), sheetN5, scale=.15, startRow=22, startColumn=24 )
  # addPicture(paste("picts/NMF5-2Correlation.png"), sheetN5, scale=.15, startRow=22, startColumn=27 )
  # addPicture(paste("picts/NMF5-2CorGaussian.png"), sheetN5, scale=.15, startRow=22, startColumn=30 )
  # addPicture(paste("picts/NMF5-2Gaussian.png"), sheetN5, scale=.15, startRow=22, startColumn=33 )
  # 
  # addPicture(paste("picts/NMF5-3Cluster.png"), sheetN5, scale=.15, startRow=29, startColumn=24 )
  # addPicture(paste("picts/NMF5-3Correlation.png"), sheetN5, scale=.15, startRow=29, startColumn=27 )
  # addPicture(paste("picts/NMF5-3CorGaussian.png"), sheetN5, scale=.15, startRow=29, startColumn=30 )
  # addPicture(paste("picts/NMF5-3Gaussian.png"), sheetN5, scale=.15, startRow=29, startColumn=33 )
  # 
  # addPicture(paste("picts/NMF5-4Cluster.png"), sheetN5, scale=.15, startRow=36, startColumn=24 )
  # addPicture(paste("picts/NMF5-4Correlation.png"), sheetN5, scale=.15, startRow=36, startColumn=27 )
  # addPicture(paste("picts/NMF5-4CorGaussian.png"), sheetN5, scale=.15, startRow=36, startColumn=30 )
  # addPicture(paste("picts/NMF5-4Gaussian.png"), sheetN5, scale=.15, startRow=36, startColumn=33 )
  # 
  # addPicture(paste("picts/NMF5-5Cluster.png"), sheetN5, scale=.15, startRow=43, startColumn=24 )
  # addPicture(paste("picts/NMF5-5Correlation.png"), sheetN5, scale=.15, startRow=43, startColumn=27 )
  # addPicture(paste("picts/NMF5-5CorGaussian.png"), sheetN5, scale=.15, startRow=43, startColumn=30 )
  # addPicture(paste("picts/NMF5-5Gaussian.png"), sheetN5, scale=.15, startRow=43, startColumn=33 )
  # 
  # addPicture(paste("picts/NMF5-AllCluster.png"), sheetN5, scale=.15, startRow=50, startColumn=24 )
  # addPicture(paste("picts/NMF5-AllCorrelation.png"), sheetN5, scale=.15, startRow=50, startColumn=27 )
  # addPicture(paste("picts/NMF5-AllCorGaussian.png"), sheetN5, scale=.15, startRow=50, startColumn=30 )
  # addPicture(paste("picts/NMF5-AllGaussian.png"), sheetN5, scale=.15, startRow=50, startColumn=33 )
  
  addPicture(paste("picts/NMF1by2Plot5.png"), sheetN5, scale=.3, startRow=60, startColumn=23 )
  addPicture(paste("picts/NMF1by3Plot5.png"), sheetN5, scale=.3, startRow=60, startColumn=28 )
  gc()
  
  }  # end if(k==5)
  
  if(knum==6) {
    
    #  -------------Update AllScores  
    if(as.numeric(sum(NMFPScores6)/6)<.05) {AllScores["NMF6",colnames(data.NMFTop6)] <- 1}  else {AllScores <- AllScores[!rownames(AllScores) %in% "NMF6",]}
    
    
    avg6 <- as.data.frame(sum(NMFPScores6)/6, row.names="Average")
    NMFCmpds6Tmp <- as.data.frame(cbind(as.matrix(lookup[rownames(NMFCmpds6),2]), (lookup[rownames(NMFCmpds2),4]), (lookup[rownames(NMFCmpds2),6:7]), NMFCmpds6))
    colnames(NMFCmpds6Tmp)[1:2] <- c("Name","MF")
    NMFSmpls6Tmp <- as.data.frame(cbind(as.data.frame(deSign[,3]), NMFSmpls6))
    NMFPScores6Tmp <- as.data.frame(NMFPScores6[,])
    
    if(as.numeric(sum(NMFPScores6)/6)<.05) {AllScores["NMF6",colnames(data.NMFTop6)] <- 1}  else {AllScores <- AllScores[!rownames(AllScores) %in% "NMF6",]}
    
    write.table(lookup[NMFTopCmpds6[NMFTopCmpds6$NMF.Level=="NMF6-1 Cluster",1],3], file="concept/NMF6-1.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds6[NMFTopCmpds6$NMF.Level=="NMF6-2 Cluster",1],3], file="concept/NMF6-2.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds6[NMFTopCmpds6$NMF.Level=="NMF6-3 Cluster",1],3], file="concept/NMF6-3.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds6[NMFTopCmpds6$NMF.Level=="NMF6-4 Cluster",1],3], file="concept/NMF6-4.txt", row.names=F, col.names = c("CID") )
    write.table(lookup[NMFTopCmpds6[NMFTopCmpds6$NMF.Level=="NMF6-5 Cluster",1],3], file="concept/NMF6-5.txt", row.names=F, col.names = c("CID") )  
    write.table(lookup[NMFTopCmpds6[NMFTopCmpds6$NMF.Level=="NMF6-6 Cluster",1],3], file="concept/NMF6-6.txt", row.names=F, col.names = c("CID") )
    
  #sheetN6 <- createSheet(wb, sheetName = paste("NMF6"))
  sheetN6 <- sheets[[15]]
  
  # addDataFrame(junk, sheetN6, startRow=15, startColumn=1, col.names=T, row.names=F)
  addDataFrame(NMFCmpds6Tmp, sheetN6, startRow=15, startColumn=1, col.names=T, row.names=T)
  addDataFrame(NMFSmpls6Tmp, sheetN6, startRow=15, startColumn=length(NMFCmpds6Tmp)+3, col.names=T, row.names=T)
  addDataFrame(NMFPScores6, sheetN6, startRow=15, startColumn=length(NMFCmpds6Tmp)+length(NMFSmpls6Tmp)+5, col.names=T, row.names=T)
  addDataFrame(avg6, sheetN6, startRow=23, startColumn=length(NMFCmpds6Tmp)+length(NMFSmpls6Tmp)+5, col.names=F, row.names=T)
  addDataFrame(NMFplist6, sheetN6, startRow=25, startColumn=length(NMFCmpds6Tmp)+length(NMFSmpls6Tmp)+6, col.names=F, row.names=F)
  
  addPicture(paste("picts/NMFHeatMap6.png"), sheetN6, scale=.3, startRow=2, startColumn=3 )
  addPicture(paste("picts/NMFALLPlot6.png"), sheetN6, scale=.3, startRow=2, startColumn=9 )
  addPicture(paste("picts/NMFSamples6.png"), sheetN6, scale=.3, startRow=2, startColumn=15 )
  addPicture(paste("picts/NMFrecastHeatMap6.png"), sheetN6, scale=.3, startRow=2, startColumn=22 )
  addPicture(paste("picts/NMFAvgPPlot.png"), sheetN6, scale=.4, startRow=2, startColumn=27 )
  
  # addPicture(paste("picts/NMF6-1Cluster.png"), sheetN6, scale=.15, startRow=15, startColumn=26 )
  # addPicture(paste("picts/NMF6-1Correlation.png"), sheetN6, scale=.15, startRow=15, startColumn=29 )
  # addPicture(paste("picts/NMF6-1CorGaussian.png"), sheetN6, scale=.15, startRow=15, startColumn=32 )
  # addPicture(paste("picts/NMF6-1Gaussian.png"), sheetN6, scale=.15, startRow=15, startColumn=35 )
  # 
  # addPicture(paste("picts/NMF6-2Cluster.png"), sheetN6, scale=.15, startRow=22, startColumn=26 )
  # addPicture(paste("picts/NMF6-2Correlation.png"), sheetN6, scale=.15, startRow=22, startColumn=29 )
  # addPicture(paste("picts/NMF6-2CorGaussian.png"), sheetN6, scale=.15, startRow=22, startColumn=32 )
  # addPicture(paste("picts/NMF6-2Gaussian.png"), sheetN6, scale=.15, startRow=22, startColumn=35 )
  # 
  # addPicture(paste("picts/NMF6-3Cluster.png"), sheetN6, scale=.15, startRow=29, startColumn=26 )
  # addPicture(paste("picts/NMF6-3Correlation.png"), sheetN6, scale=.15, startRow=29, startColumn=29 )
  # addPicture(paste("picts/NMF6-3CorGaussian.png"), sheetN6, scale=.15, startRow=29, startColumn=32 )
  # addPicture(paste("picts/NMF6-3Gaussian.png"), sheetN6, scale=.15, startRow=29, startColumn=35 )
  # 
  # addPicture(paste("picts/NMF6-4Cluster.png"), sheetN6, scale=.15, startRow=36, startColumn=26 )
  # addPicture(paste("picts/NMF6-4Correlation.png"), sheetN6, scale=.15, startRow=36, startColumn=27 )
  # addPicture(paste("picts/NMF6-4CorGaussian.png"), sheetN6, scale=.15, startRow=36, startColumn=32 )
  # addPicture(paste("picts/NMF6-4Gaussian.png"), sheetN6, scale=.15, startRow=36, startColumn=35 )
  # 
  # addPicture(paste("picts/NMF6-5Cluster.png"), sheetN6, scale=.15, startRow=43, startColumn=26 )
  # addPicture(paste("picts/NMF6-5Correlation.png"), sheetN6, scale=.15, startRow=43, startColumn=29 )
  # addPicture(paste("picts/NMF6-5CorGaussian.png"), sheetN6, scale=.15, startRow=43, startColumn=32 )
  # addPicture(paste("picts/NMF6-5Gaussian.png"), sheetN6, scale=.15, startRow=43, startColumn=35 )
  # 
  # addPicture(paste("picts/NMF6-6Cluster.png"), sheetN6, scale=.15, startRow=50, startColumn=26 )
  # addPicture(paste("picts/NMF6-6Correlation.png"), sheetN6, scale=.15, startRow=50, startColumn=29 )
  # addPicture(paste("picts/NMF6-6CorGaussian.png"), sheetN6, scale=.15, startRow=50, startColumn=32 )
  # addPicture(paste("picts/NMF6-6Gaussian.png"), sheetN6, scale=.15, startRow=50, startColumn=35 )
  
  #addPicture(paste("picts/NMF6-AllCluster.png"), sheetN6, scale=.15, startRow=57, startColumn=26 )
  #addPicture(paste("picts/NMF6-AllCorrelation.png"), sheetN6, scale=.15, startRow=57, startColumn=29 )
  #addPicture(paste("picts/NMF6-AllCorGaussian.png"), sheetN6, scale=.15, startRow=57, startColumn=32 )
  #addPicture(paste("picts/NMF6-AllGaussian.png"), sheetN6, scale=.15, startRow=57, startColumn=35 )
  
  addPicture(paste("picts/NMF1by2Plot6.png"), sheetN6, scale=.3, startRow=67, startColumn=23 )
  addPicture(paste("picts/NMF1by3Plot6.png"), sheetN6, scale=.3, startRow=67, startColumn=28 )
  gc()
  
  }  # end if(k==6)
  
     NMFList <- list(
       basis = basisPlus,
       sCoefPlus  = scaledCoefPlus,
       #NMFTopdata = data.NMFTop1,
       #data  = data.NMFTop3, # used for AllScores
       pScores = nmfPScores,
       plist = plist,
       avg = avgPScore,
       nmfStats = NMFStats,
       topPredictors = topPredictors
       
       # saveWorkbook(wb, paste("reports/RR_TEST.xlsx", sep=""), overwrite = T ) # for debug
     ) # end list
     
  # all done store and finish
     return(NMFList) # end of return

}  # end of function NMFTabs

ScoreCmpds <- function() {

  #   wb <- createWorkbook()   # for debug
  
  ##  Compound Summary
  #Summarize top compounds, first build table then draw each  
  AllScores <- DATA[1:9,]
  colnames(AllScores) <- colnames(DATA)
  rownames(AllScores) <- c("Anova1", "RF1", "RF2", "PCA1", "NMF2", "NMF3", "NMF4", "NMF5", "NMF6" )
  AllScores[,] <- 0
  
  #   ------------- update AllScores according to their presence as a row in top lists
  #Test <- colnames(data.pTop1)
  AllScores["Anova1",colnames(StatList[[ListNum]]$pTOP1)] <- 1
  AllScores["RF1",colnames(RFList[[ListNum]]$rfTOP1)] <- 1
  AllScores["RF2",colnames(RFList[[ListNum]]$rfTOP2)] <- 1
  AllScores["PCA1",colnames(PCAList[[ListNum]]$pcaTOP1)] <- 1
  AllScores["NMF3",colnames(RFNMFList[[ListNum]]$data)]  <- 1

  temp <- as.matrix(t(colSums(AllScores[,])))
  rownames(temp) <- c("Count")
  AllScores <- rbind(AllScores, temp )
  
  temp2 <-  as.data.frame(t(AllScores))
  temp3 <- temp2[temp2$Count>=trunc(max(temp/2)),]
  temp4 <- temp3[ order(-temp3[,"Count"]),]
  AllScores <- as.data.frame(temp4[,])
  
  test <- colSums(AllScores)
  FilledScores <- AllScores[,test>=1]

  # add chemical info
  allS <- rownames(FilledScores)
  plus <- lookup[allS,c(1,2,4)]
  
  # add labnum to Allscores
  LabNum <- as.data.frame(FilledScores[,1])
  colnames(LabNum) <- c("LabNum")
  LabNum[,1] <- c(tkn)
  
  AllScores <- cbind(LabNum, plus, FilledScores)  
  
  junkSummary <- as.matrix(lookup[rownames(temp4),2])
  colnames(junkSummary)[1] <- "Name"
  
  names <- rownames(AllScores)
  for(i in 1:nrow(AllScores) ) { 
    name <- names[i]
    fullname <- lookup[name,2]
    mf <- lookup[name,4]
    
    pname <- paste("picts/Cmpd_", name, ".png", sep="")
    png(pname)
    par(mfrow=c(1,2), mar=c(3,2,1.5,.5), oma = c(0.5,0.5,3,0))
    plot(DATA[,name], col=listByGroup, pch=20, cex=3, xlab = "by Sample Number", ylab = "abundance" )
    #title(paste(name, " - ", fullname), cex.main=2, font=3) 
    #devOff() 
    boxplot(DATA[,name]~deSign[,3], col=list, xlab = "by Type", yaxis=F)
    mtext(paste(name, " - ", fullname), outer=TRUE, cex.main=2, font=2) 
    devOff() 
  }
  
  # ---------end analysis/summary write lab report page
  
  addWorksheet(wb, "Scored_Cmpds") 
  ht <- nrow(AllScores)+10
 
  Stamp <- as.data.frame(paste("This tab has graphs of potentially significant compounds. "))
  writeData(wb, "Scored_Cmpds", Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
  writeData(wb, "Scored_Cmpds", AllScores, startRow=3, startCol=1, colNames=T, rowNames=F)
  
  setColWidths(wb, "Scored_Cmpds", cols=c(2:4), widths = 22)
  setColWidths(wb, "Scored_Cmpds", cols=c(1,5:9), widths = 8)
  conditionalFormatting(wb, "Scored_Cmpds",  rule = "=4", style=createStyle(bgFill = "red"), rows=4:ht, cols= c(9), gridExpand=T, stack=T )
  conditionalFormatting(wb, "Scored_Cmpds",  rule = "=3", style=createStyle(bgFill = "orange"), rows=4:ht, cols= c(9), gridExpand=T, stack=T )

  insertImage(wb, "Scored_Cmpds", "picts/legend.png", width=4, height=4, startRow=2, startCol=11 )
  
  for(i in 1:nrow(temp4) ) {  
    name <- names[i]
    pname <- paste("picts/Cmpd_", name, ".png", sep="")
    j <- (i %% 5)+1
    k <- (i%/%5)
    
    insertImage(wb, "Scored_Cmpds", pname, width=2, height=2, 4+(k*10), startCol=9+(3*j) )
  }
  
  #assign(SummStat, AllScores, pos=1 )          # used
  retlist <- list(
    allscores = AllScores
  ) # end list
  
  # all done store and finish
  return(retlist) # end of return
  
}  # end Function ScoreCmpds

GroupCmpds <- function() {
  #  wb <- createWorkbook()  #  for debug
  print("start GroupCmpds")
  
  AllGroups <- DATA[1:5,]
  colnames(AllGroups) <- colnames(DATA)
  rownames(AllGroups) <- c("Anova", "RF", "PCA", "NMF3", "NMF2" )
  AllGroups <- t(AllGroups)
  AllGroups[,] <- ""
  #groups <- levels(deSign$GroupFactor)
  
  #   ------------- update AllGroups
  stat <- StatNMFList[[tkn]]$sCoefPlus[,c(2,10)]
  RF <- RFNMFList[[tkn]]$sCoefPlus[,c(2,10)]
  PCA <- PCANMFList[[tkn]]$sCoefPlus[,c(2,10)]
  #NMF2 <- NMF2List[[tkn]]$sCoefPlus[,c(2,10)]
  NMF3 <- NMF3List[[tkn]]$sCoefPlus[,c(2,10)]
  for(i in 1:length(groups)) {
  AllGroups[rownames(stat[stat$Group==groups[i],]),"Anova"] <- groups[i]
  AllGroups[rownames(RF[RF$Group==groups[i],]),"RF"] <- groups[i]
  AllGroups[rownames(PCA[PCA$Group==groups[i],]),"PCA"] <- groups[i]
  AllGroups[rownames(NMF3[NMF3$Group==groups[i],]),"NMF3"] <- groups[i]
  }
  
  
  #AllGroups[rownames(stat[stat$Group=="Not clear",]),"Anova"] <- "NotClr"
  
  #RF <- RFNMFList[[tkn]]$sCoefPlus[,c(2,10)]
  # AllGroups[rownames(RF[RF$Group==groups[1],]),"RF"] <- groups[1]
  # AllGroups[rownames(RF[RF$Group==groups[2],]),"RF"] <- groups[2]
  # AllGroups[rownames(RF[RF$Group==groups[3],]),"RF"] <- groups[3]
  # AllGroups[rownames(RF[RF$Group=="Not clear",]),"RF"] <- "NotClr"
  
  PCA <- PCANMFList[[tkn]]$sCoefPlus[,c(2,10)]
  AllGroups[rownames(PCA[PCA$Group==groups[1],]),"PCA"] <- groups[1]
  AllGroups[rownames(PCA[PCA$Group==groups[2],]),"PCA"] <- groups[2]
  AllGroups[rownames(PCA[PCA$Group==groups[3],]),"PCA"] <- groups[3]
  AllGroups[rownames(PCA[PCA$Group=="Not clear",]),"PCA"] <- "NotClr"
  
  NMF <- NMF3List[[tkn]]$sCoefPlus[,c(2,10)]
  AllGroups[rownames(NMF[NMF$Group==groups[1],]),"NMF3"] <- groups[1]
  AllGroups[rownames(NMF[NMF$Group==groups[2],]),"NMF3"] <- groups[2]
  AllGroups[rownames(NMF[NMF$Group==groups[3],]),"NMF3"] <- groups[3]
  AllGroups[rownames(NMF[NMF$Group=="Not clear",]),"NMF3"] <- "NotClr"
  
  AllGroup2 <- AllGroups[!apply(AllGroups == "", 1, all),]
  
  count <- as.data.frame(rowSums(nchar(AllGroup2[,]))/6 )
  colnames(count) <- c("Count")
  
  # add labnum to AllGroups
  LabNum <- as.data.frame(AllGroup2[,1])
  colnames(LabNum) <- c("LabNum")
  LabNum[,1] <- c(tkn)
  
  allS <- rownames(AllGroup2)
  chem <- lookup[allS,c(1,2,4)]
  
  AllGroups <- cbind(LabNum, chem, AllGroup2, count)
  
  AllGroups <- AllGroups[order(-AllGroups$Count, AllGroups$MF, AllGroups$Name),]

  # generate the images based on AllGroups
  print("start GroupCmpd images")
  names <- rownames(AllGroups)
  for(i in 1:nrow(AllGroups) ) { 
    name <- names[i]
    fullname <- lookup[name,2]
    mf <- lookup[name,4]
    
    pname <- paste("picts/Cmpd_", name, ".png", sep="")
    png(pname)
    par(mfrow=c(1,2), mar=c(3,2,1.5,.5), oma = c(0.5,0.5,3,0))
    plot(DATA[,name], col=listByGroup, pch=20, cex=3, xlab = "by Sample Number", ylab = "abundance" )
    boxplot(DATA[,name]~deSign[,3], col=list, xlab = "by Type", yaxis=F)
    mtext(paste(name, " - ", fullname), outer=TRUE, cex.main=2, font=2) 
    devOff() 
  }
  
  # -----------------------------------------------end analysis/build page 
  
  addWorksheet(wb, "Grouped_Cmpds")
  ht <- nrow(AllGroups)+10
  conditionalFormatting(wb, "Grouped_Cmpds",  rule = "=4", style=createStyle(bgFill = "red"), rows=4:ht, cols= c(9), gridExpand=T, stack=T )
  conditionalFormatting(wb, "Grouped_Cmpds",  rule = "=3", style=createStyle(bgFill = "orange"), rows=4:ht, cols= c(9), gridExpand=T, stack=T )
 
  
  Stamp <- as.data.frame(paste("This tab has graphs of potentially significant compounds and their biomarkers according to each analysis. "))
  writeData(wb, "Grouped_Cmpds", Stamp, startRow=1, startCol=1, colNames=F, rowNames=F)
  writeData(wb, "Grouped_Cmpds", AllGroups, startRow=3, startCol=1, colNames=T, rowNames=F)
  setColWidths(wb, "Grouped_Cmpds", cols=c(2:4), widths = 22)
  setColWidths(wb, "Grouped_Cmpds", cols=c(1,5:9), widths = 8)
  
  insertImage(wb, "Grouped_Cmpds", "picts/legend.png", width=4, height=4, startRow=2, startCol=11 )
  
  for(i in 1:nrow(AllGroups) ) {  
    name <- names[i]
    pname <- paste("picts/Cmpd_", name, ".png", sep="")
    j <- (i %% 5)+1
    k <- (i%/%5)
    
    insertImage(wb, "Grouped_Cmpds", pname, width=2, height=2, 4+(k*10), startCol=9+(3*j) )
  }
  
  retlist <- list(
    AllGroups = AllGroups
  ) # end list
  
  # all done store and finish
  return(retlist) # end of return
  
} # end Function GroupCmpds

renormalize <- function() {
  
  # reNormalize based on MSTUS populations
  SCC12sums <- rowSums(MSTUSdataSC)
  SCC13sums <- rowSums(MSTUSdataC13SC)
  for(i in 1:nrow(MSTUSdataSC)) {   # i is for rows
    NF <- SCC12sums[i]/SCC13sums[i]
    for(j in 1:ncol(MSTUSdataSC)) {   # j is for cols
      MSTUSdataNormalized[i,j] <- MSTUSdataSC[i,j]/NF
    }    # end for MSTUSdataSC
    for(j in 1:ncol(dataSC)) {   # j is for cols
      if(dataSC[i,j]>2) {
        dataNormalized[i,j] <- dataSC[i,j]/NF
      }  # end if
    }    # end for dataSC
  }      # end for
  return(MSTUSdataNormalized)
}  # end of renormalization

testrenorm <- function() {
  #Test to recalculate Data - This is a debug test
  #need to remove standin "1" from ratios
  
  
  MSTUSC12SC.recast <- MSTUSdataC13SC
  MSTUSC12SC.recast[,] <- 0
  
  for(i in 1:ncol(MSTUSdataC13SC)) {   # cols
    for(j in 1:nrow(MSTUSdataC13SC)) { # rows
      MSTUSC12SC.recast[j,i] <- MSTUSdataC13SC[j,i] * MSTUSdataRatio[j,i]
    }  # end of rows
  }  # end of cols
  
  MSTUSC12SC.test <- MSTUSdataC13SC
  MSTUSC12SC.test[,] <- 0
  
  for(i in 1:ncol(MSTUSdataC13SC)) {   # cols
    for(j in 1:nrow(MSTUSdataC13SC)) { # rows
      MSTUSC12SC.test[j,i] <- MSTUSdataSC[j,i] - MSTUSC12SC.recast[j,i]
    }  # end of rows
  }  # end of cols
  return(MSTUSC12SC.test)
}   # end of function testrenorm
